package lecture;

import java.util.*;
import java.io.*;

public class Lectcolonne{
    /**
     * Analyse une chaîne de caractères pour renvoyer la valeur située à la k-ème position. On suppose que les valeurs sont séparées par des ";"
     * @param ligne : la chaîne de caractères
     * @param k : position de la valeur recherchée
     */
    private static double getNthColumnDouble(String ligne, int k) throws Exception {
	StringTokenizer st = new StringTokenizer(ligne, ";");
	if (st.countTokens() >= k) {
	    String sval=null;
	    for (int i=0; i < k; i++) {
		sval = st.nextToken();
	    }
	    try { 
		return(new Double(sval));
	    }
	    catch(NumberFormatException e) {
		throw new Exception("La valeur n'est pas un double");
	    }
	} else {
	    throw new Exception("Il n' a que " + st.countTokens() + " valeurs sur la ligne");
	}
    }


    /**
     * Lit depuis un fichier une colonne de valeur
     * @param nf : le nom du fichier
     * @param column : le numéro de la colonne (1 pour la première colonne)
     */ 
    public static Double[] lire(String nf,int column) {
	int i = 0;;
	String ligne;
	Vector<Double> result = new Vector<Double>();

	try {
	    FileReader fr = new FileReader(nf);
	    BufferedReader bf = new BufferedReader(fr);
	    ligne = bf.readLine();
	    while (ligne != null) { // jusqu'à la fin du fichier
		i++;
		result.add(getNthColumnDouble(ligne, column));
		ligne = bf.readLine();
	    }	    
	    bf.close();
	    fr.close();
	    return(result.toArray(new Double[1]));
	    
	} catch (Exception e) {
	    // il y a eu un problème, on affiche une erreur et on renvoie null
	    System.err.println("Problème à la lecture du fichier "+nf+" ligne " +i);
	    e.printStackTrace();
	    return(null);
	} 
    }
}
